/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.access;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.util.Objects;
import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.InheritableThreadLocalStack;
import net.java.truecommons.shed.Resource;
import net.java.truevfs.access.TArchiveDetector;
import net.java.truevfs.kernel.spec.FsAccessOption;
import net.java.truevfs.kernel.spec.FsAccessOptions;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.sl.FsManagerLocator;

@CleanupObligation
public final class TConfig
extends Resource<IllegalStateException> {
    private static final BitField<FsAccessOption> NOT_ACCESS_PREFERENCES_MASK = FsAccessOptions.ACCESS_PREFERENCES_MASK.not();
    private static final InheritableThreadLocalStack<TConfig> configs = new InheritableThreadLocalStack();
    static final TConfig GLOBAL = new TConfig();
    private FsManager manager;
    private TArchiveDetector detector;
    private BitField<FsAccessOption> preferences;

    public static TConfig current() {
        return (TConfig)((Object)configs.peekOrElse((Object)GLOBAL));
    }

    @CreatesObligation
    public static TConfig open() {
        return (TConfig)((Object)configs.push((Object)new TConfig(TConfig.current())));
    }

    private TConfig() {
        this.manager = FsManagerLocator.SINGLETON.get();
        this.detector = TArchiveDetector.ALL;
        this.preferences = BitField.of((Enum)FsAccessOption.CREATE_PARENTS);
    }

    private TConfig(TConfig template) {
        this.manager = template.getManager();
        this.detector = template.getArchiveDetector();
        this.preferences = template.getAccessPreferences();
    }

    private void checkOpen() {
        if (!this.isOpen()) {
            throw new IllegalStateException("This configuration has already been close()d.");
        }
    }

    FsManager getManager() {
        this.checkOpen();
        return this.manager;
    }

    void setManager(FsManager manager) {
        this.checkOpen();
        this.manager = Objects.requireNonNull(manager);
    }

    public TArchiveDetector getArchiveDetector() {
        this.checkOpen();
        return this.detector;
    }

    public void setArchiveDetector(TArchiveDetector detector) {
        this.checkOpen();
        this.detector = Objects.requireNonNull(detector);
    }

    public BitField<FsAccessOption> getAccessPreferences() {
        this.checkOpen();
        return this.preferences;
    }

    public void setAccessPreferences(BitField<FsAccessOption> preferences) {
        this.checkOpen();
        if (preferences.equals(this.preferences)) {
            return;
        }
        BitField illegal = preferences.and(NOT_ACCESS_PREFERENCES_MASK);
        if (!illegal.isEmpty()) {
            throw new IllegalArgumentException(illegal + " (illegal access preference(s))");
        }
        if (preferences.get((Enum)FsAccessOption.STORE) && preferences.get((Enum)FsAccessOption.COMPRESS)) {
            throw new IllegalArgumentException(preferences + " (either STORE or COMPRESS may be set, but not both)");
        }
        this.preferences = preferences;
    }

    public boolean getAccessPreference(FsAccessOption option) {
        return this.getAccessPreferences().get((Enum)option);
    }

    public void setAccessPreference(FsAccessOption option, boolean set) {
        this.setAccessPreferences((BitField<FsAccessOption>)this.getAccessPreferences().set((Enum)option, set));
    }

    public boolean isLenient() {
        return this.getAccessPreference(FsAccessOption.CREATE_PARENTS);
    }

    public void setLenient(boolean lenient) {
        this.setAccessPreference(FsAccessOption.CREATE_PARENTS, lenient);
    }

    @DischargesObligation
    public void close() throws IllegalStateException {
        super.close();
    }

    protected void onBeforeClose() throws IllegalStateException {
        configs.popIf((Object)this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TConfig)) {
            return false;
        }
        TConfig that = (TConfig)((Object)other);
        return this.manager.equals(that.getManager()) && this.detector.equals((Object)that.getArchiveDetector()) && this.preferences.equals(that.getAccessPreferences());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.manager.hashCode();
        hash = 89 * hash + this.detector.hashCode();
        hash = 89 * hash + this.preferences.hashCode();
        return hash;
    }

    public String toString() {
        return String.format("%s[manager=%s, detector=%s, preferences=%s]", new Object[]{((Object)((Object)this)).getClass().getName(), this.manager, this.detector, this.preferences});
    }
}

